/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.GeometryUtil;
import qouteall.q_misc_util.my_util.Mesh2D;

public class GeometryPortalShape {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_TRIANGLE_NUM = 10000;
    public List<TriangleInPlane> triangles;
    public boolean normalized = false;

    private static boolean isOnLeftSideOfTheLine(double x, double y, double x1, double y1, double x2, double y2, double leniency) {
        double cross = Helper.crossProduct2D(x - x1, x2 - x1, y - y1, y2 - y1);
        if (leniency == 0.0) {
            return cross >= 0.0;
        }
        return cross >= -leniency * Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public GeometryPortalShape() {
        this.triangles = new ArrayList<TriangleInPlane>();
    }

    public GeometryPortalShape(List<TriangleInPlane> triangles) {
        this.triangles = triangles;
    }

    public GeometryPortalShape(ListTag tag) {
        this.triangles = new ArrayList<TriangleInPlane>();
        int size = tag.size();
        if (size % 6 != 0) {
            Helper.err("Bad Portal Shape Data " + String.valueOf(tag));
            return;
        }
        int triangleNum = size / 6;
        for (int i = 0; i < triangleNum; ++i) {
            this.triangles.add(new TriangleInPlane(tag.m_128772_(i * 6 + 0), tag.m_128772_(i * 6 + 1), tag.m_128772_(i * 6 + 2), tag.m_128772_(i * 6 + 3), tag.m_128772_(i * 6 + 4), tag.m_128772_(i * 6 + 5)));
        }
    }

    public ListTag writeToTag() {
        ListTag tag = new ListTag();
        for (TriangleInPlane triangle : this.triangles) {
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x1));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y1));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x2));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y2));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x3));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y3));
        }
        return tag;
    }

    public void addTriangleForRectangle(double x1, double y1, double x2, double y2) {
        this.triangles.add(new TriangleInPlane(x1, y1, x2, y1, x2, y2));
        this.triangles.add(new TriangleInPlane(x2, y2, x1, y2, x1, y1));
    }

    public void normalize(double width, double height) {
        if (width == 0.0 || height == 0.0) {
            LOGGER.error("Trying to normalize with width {} and height {}", (Object)width, (Object)height);
            return;
        }
        if (!this.normalized) {
            double halfWidth = width / 2.0;
            double halfHeight = height / 2.0;
            for (TriangleInPlane triangle : this.triangles) {
                triangle.x1 /= halfWidth;
                triangle.y1 /= halfHeight;
                triangle.x2 /= halfWidth;
                triangle.y2 /= halfHeight;
                triangle.x3 /= halfWidth;
                triangle.y3 /= halfHeight;
            }
            this.normalized = true;
        }
    }

    public boolean isValid() {
        return !this.triangles.isEmpty();
    }

    public GeometryPortalShape getFlippedWithScaling(double scale) {
        List<TriangleInPlane> newTriangleList = this.triangles.stream().map(triangle -> new TriangleInPlane(-triangle.x1 * scale, triangle.y1 * scale, -triangle.x2 * scale, triangle.y2 * scale, -triangle.x3 * scale, triangle.y3 * scale)).toList();
        GeometryPortalShape result = new GeometryPortalShape(newTriangleList);
        result.normalized = this.normalized;
        return result;
    }

    public Mesh2D toMesh() {
        Validate.isTrue((boolean)this.normalized);
        Mesh2D result = new Mesh2D();
        for (TriangleInPlane triangle : this.triangles) {
            result.addTriangle(triangle.x1, triangle.y1, triangle.x2, triangle.y2, triangle.x3, triangle.y3);
        }
        return result;
    }

    public static GeometryPortalShape fromMesh(Mesh2D mesh2D) {
        GeometryPortalShape result = new GeometryPortalShape();
        result.normalized = true;
        for (int i = 0; i < mesh2D.getStoredTriangleNum(); ++i) {
            if (!mesh2D.isTriangleValid(i)) continue;
            int pointIndex1 = mesh2D.trianglePointIndexes.getInt(i * 3);
            int pointIndex2 = mesh2D.trianglePointIndexes.getInt(i * 3 + 1);
            int pointIndex3 = mesh2D.trianglePointIndexes.getInt(i * 3 + 2);
            double x1 = mesh2D.pointCoords.getDouble(pointIndex1 * 2);
            double y1 = mesh2D.pointCoords.getDouble(pointIndex1 * 2 + 1);
            double x2 = mesh2D.pointCoords.getDouble(pointIndex2 * 2);
            double y2 = mesh2D.pointCoords.getDouble(pointIndex2 * 2 + 1);
            double x3 = mesh2D.pointCoords.getDouble(pointIndex3 * 2);
            double y3 = mesh2D.pointCoords.getDouble(pointIndex3 * 2 + 1);
            result.triangles.add(new TriangleInPlane(x1, y1, x2, y2, x3, y3));
            if (result.triangles.size() >= 10000) break;
        }
        return result;
    }

    public GeometryPortalShape simplified() {
        Mesh2D mesh2D = this.toMesh();
        mesh2D.simplify();
        return GeometryPortalShape.fromMesh(mesh2D);
    }

    public static GeometryPortalShape createDefault() {
        GeometryPortalShape result = new GeometryPortalShape();
        result.addTriangleForRectangle(-1.0, -1.0, 1.0, 1.0);
        result.normalized = true;
        return result;
    }

    public boolean boxIntersects(double minX, double minY, double maxX, double maxY) {
        return this.triangles.stream().anyMatch(t -> GeometryUtil.triangleIntersectsWithAABB(t.x1, t.y1, t.x2, t.y2, t.x3, t.y3, minX, minY, maxX, maxY));
    }

    public static class TriangleInPlane {
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        public double x3;
        public double y3;

        public TriangleInPlane(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
            if (!this.isCounterClockWise()) {
                this.x2 = x3;
                this.y2 = y3;
                this.x3 = x2;
                this.y3 = y2;
                assert (this.isCounterClockWise());
            }
        }

        public boolean isCounterClockWise() {
            return GeometryPortalShape.isOnLeftSideOfTheLine(this.x3, this.y3, this.x1, this.y1, this.x2, this.y2, 0.0);
        }

        public boolean isPointInTriangle(double x, double y) {
            return this.lenientIsPointInTriangle(x, y, 0.0);
        }

        public boolean lenientIsPointInTriangle(double x, double y, double leniency) {
            assert (this.isCounterClockWise());
            return GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x1, this.y1, this.x2, this.y2, leniency) && GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x2, this.y2, this.x3, this.y3, leniency) && GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x3, this.y3, this.x1, this.y1, leniency);
        }

        public double getArea() {
            return Helper.crossProduct2D(this.x2 - this.x1, this.y2 - this.y1, this.x3 - this.x1, this.y3 - this.y1) / -2.0;
        }
    }
}

